<?php

namespace Modules\Episode\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Schema;
use Modules\Episode\Models\Episode;
use Modules\MenuBuilder\Models\MenuBuilder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class EpisodeDatabaseSeeder extends Seeder
{

    public function run()
        {
            Schema::disableForeignKeyConstraints();

            $episodes = [
                [
                    'name' => 'S1 E1 The Awakening',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_awakening_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_awakening_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 1,
                    'short_desc' => 'A series of mysterious events awaken an ancient evil. 😱',
                    'description' => 'The team must uncover the truth behind these occurrences before it\'s too late. A series of mysterious events awaken an ancient evil. 😱',
                    'trailer_url' => 'https://youtu.be/7_MJp5AbSwA?si=Mtx9h0wlxtn4o_2Q',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:56',
                    'release_date' => '2019-04-23',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/mBYGUn6Q7tQ?si=2ijlo4497ab-ZMpU',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 The Haunted',
                    'poster_url' => '/dummy-images/episode/s1_e2_the_haunted_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_awakening_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 1,
                    'short_desc' => 'The team discovers a haunted house with a dark secret. 🏚️',
                    'description' => 'As they explore, they encounter terrifying apparitions and uncover the house\'s grim history. The team discovers a haunted house with a dark secret. 🏚️',
                    'trailer_url' => 'https://www.youtube.com/watch?v=mBYGUn6Q7tQ&t=17s',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '05:13',
                    'release_date' => '2019-04-24',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/oZDzZNm4k6M?si=Hv33WihW-44xFvkm',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 The Possession',
                    'poster_url' => '/dummy-images/episode/s1_e3_the_possession_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_the_possession_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 1,
                    'short_desc' => 'One of the investigators becomes possessed by a malevolent spirit. 👻',
                    'description' => 'The team struggles to save their friend and find a way to expel the dark force. One of the investigators becomes possessed by a malevolent spirit. 👻',
                    'trailer_url' => 'https://www.youtube.com/watch?v=mBYGUn6Q7tQ&t=17s',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'IMDb_rating' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:09',
                    'release_date' => '2019-04-25',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/ng9BW-vQ_2k?si=z-uDACI2iFie0-HY',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E4 The Ritual',
                    'poster_url' => '/dummy-images/episode/s1_e4_the_ritual_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_the_ritual_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 1,
                    'short_desc' => 'The team uncovers a ritual that could banish the evil entity. 🕯️',
                    'description' => 'The team uncovers a ritual that could banish the evil entity. They must perform it correctly amidst mounting supernatural threats. 🕯️',
                    'trailer_url' => 'https://www.youtube.com/watch?v=mBYGUn6Q7tQ&t=17s',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'status' => 1,
                    'IMDb_rating' => 2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2019-04-26',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/M6EMl7HPw6M?si=b5GV20LyRV6xd5Cn',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E5 The Final Confrontation',
                    'poster_url' => '/dummy-images/episode/s1_e5_the_final_confrontation_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e5_the_final_confrontation_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 1,
                    'short_desc' => 'A climactic battle to defeat the ancient evil once and for all. ⚔️',
                    'description' => 'A climactic battle to defeat the ancient evil once and for all. The team faces their greatest challenge yet, risking everything to save humanity. ⚔️',
                    'trailer_url' => 'https://www.youtube.com/watch?v=mBYGUn6Q7tQ&t=17s',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2019-04-27',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/WHBOBgDTLak?si=zrUg1McYVIr9POWc',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E1 The Return',
                    'poster_url' => '/dummy-images/episode/s2_e1_the_return_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_the_return_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 2,
                    'short_desc' => 'The ancient evil returns, more powerful than ever. 🔥',
                    'description' => 'The ancient evil returns, more powerful than ever. The team must regroup and devise a new plan to confront this formidable foe. 🔥',
                    'trailer_url' => 'https://youtu.be/1sCBEzxF_K4?si=B-rZUby9EXaMWkKD',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2019-06-08',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/_U7wKRtf8C4?si=nGKAxMOgs9YDMEPq',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E2 The Darkness Within',
                    'poster_url' => '/dummy-images/episode/s2_e2_the_darkness_within_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e2_the_darkness_within_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 2,
                    'short_desc' => 'The team faces their darkest fears and inner demons. 🌑',
                    'description' => 'The team faces their darkest fears and inner demons. As they battle the rising shadows, personal struggles threaten to tear them apart. 🌑',
                    'trailer_url' => 'https://youtu.be/_U7wKRtf8C4?si=nGKAxMOgs9YDMEPq',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:08',
                    'release_date' => '2019-06-09',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/1sCBEzxF_K4?si=B-rZUby9EXaMWkKD',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E3 The Last Stand',
                    'poster_url' => '/dummy-images/episode/s2_e3_the_last_stand_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e3_the_last_stand_thumb.png',
                    'entertainment_id' => 1,
                    'season_id' => 2,
                    'short_desc' => 'A desperate struggle to save humanity from eternal darkness. 🛡️',
                    'description' => 'A desperate struggle to save humanity from eternal darkness. The team unites for a final stand, determined to vanquish the evil once and for all. 🛡️',
                    'trailer_url' => 'https://youtu.be/_U7wKRtf8C4?si=nGKAxMOgs9YDMEPq',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:53',
                    'release_date' => '2019-06-10',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/7_MJp5AbSwA?si=Mtx9h0wlxtn4o_2Q',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The Gunslinger Rides Again',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_gunslinger_rides_again_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_gunslinger_rides_again_thumb.png',
                    'entertainment_id' => 2,
                    'season_id' => 3,
                    'short_desc' => 'A legendary gunslinger returns to a lawless town, determined to restore order and seek redemption. 🏜️💥',
                    'description' => 'A legendary gunslinger returns to the lawless town he once fled. Haunted by his past and driven by a desire to restore order, he confronts a landscape rife with crime and corruption. As he reclaims his old territory, the townsfolk look to him as their last hope against the rampant lawlessness. But his arrival stirs up old enemies, setting the stage for a fierce struggle for control. 🌵💥',
                    'trailer_url' => 'https://youtu.be/ob8iKn-gLFI?si=sUpU_bMpIDocTFZ6',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'PG-13',
                    'duration' => '02:00',
                    'release_date' => '2020-05-03',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/8AHMiNxUuPE?si=uUIiune3aZFQPc56',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Showdown at High Noon',
                    'poster_url' => '/dummy-images/episode/s1_e2_showdown_at_high_noon_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_showdown_at_high_noon_thumb.png',
                    'entertainment_id' => 2,
                    'season_id' => 3,
                    'short_desc' => 'Tensions escalate as the gunslinger faces off against a notorious gang leader in a deadly showdown. 🕛🔥',
                    'description' => 'The gunslinger\'s return shakes the town\'s criminal underbelly, culminating in a high-stakes showdown at high noon. The notorious gang leader, determined to maintain his grip on the town, challenges the gunslinger to a deadly duel. As the sun reaches its zenith, tensions explode in a brutal face-off that will determine the town’s future. The gunslinger must draw on all his skills and courage to survive and restore justice. 🕛🔥',
                    'trailer_url' => 'https://youtu.be/iABaiZO5Vjs?si=-86t28oJD4cIwkY0',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 8,
                    'content_rating' => 'PG-14',
                    'duration' => '03:25',
                    'release_date' => '2020-05-10',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/XvJRBXhRBWo?si=MQ9HEGeXtrhyvi5o',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Into the Enchanted Forest',
                    'poster_url' => '/dummy-images/episode/s1_e1_into_the_enchanted_forest_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_into_the_enchanted_forest_thumb.png',
                    'entertainment_id' => 3,
                    'season_id' => 4,
                    'short_desc' => 'Raziel enters the mystical forest, beginning his heroic journey. 🌲✨',
                    'description' => 'Raziel steps into the enchanted forest, facing magical creatures and mysterious challenges. With determination and courage, he starts his quest to rescue his friend, encountering allies and enemies along the way. 🌲✨',
                    'trailer_url' => 'https://youtu.be/G44HxQpAcI4?si=_k-CjJMC436eRDsV',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '01:25',
                    'release_date' => '2021-06-09',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/w2wIsq-M1Ac?si=ui48aPEbC14IbJgV',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 The Guardian\'s Challenge',
                    'poster_url' => '/dummy-images/episode/s1_e2_the_guardians_challenge_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_the_guardians_challenge_thumb.png',
                    'entertainment_id' => 3,
                    'season_id' => 4,
                    'short_desc' => 'Raziel must pass a trial set by the forest guardian. 🛡️🌟',
                    'description' => 'As Raziel ventures deeper into the forest, he encounters a wise guardian who sets a challenging trial. To prove his worthiness, Raziel must solve riddles and overcome obstacles, showcasing his bravery and intelligence. 🛡️🌟',
                    'trailer_url' => 'https://youtu.be/yGkGMzupaVs?si=O0EBto49niZjBm_e',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:20',
                    'release_date' => '2021-06-16',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/1c3O3-sVFC0?si=8rPDiNHndDz_XIa-',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E1 The Hidden Fortress',
                    'poster_url' => '/dummy-images/episode/s2_e1_the_hidden_fortress_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_the_hidden_fortress_thumb.png',
                    'entertainment_id' => 3,
                    'season_id' => 5,
                    'short_desc' => 'Raziel discovers Gothel\'s secret fortress and plans his next move. 🏰🔍',
                    'description' => 'Raziel uncovers the location of Gothel\'s hidden fortress, a dark and formidable structure. With newfound allies, he devises a daring plan to infiltrate the fortress and rescue his friend, facing greater dangers than ever before. 🏰🔍',
                    'trailer_url' => 'https://youtu.be/0R3YS_k6a5E?si=k1-dG2Wqap3vkvGQ',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '01:05',
                    'release_date' => '2021-07-08',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/M2aTryFM6Kg?si=aK8poGJaCpbR5J86',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E2 The Final Showdown',
                    'poster_url' => '/dummy-images/episode/s2_e2_the_final_showdown_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e2_the_final_showdown_thumb.png',
                    'entertainment_id' => 3,
                    'season_id' => 5,
                    'short_desc' => 'Raziel confronts Gothel in an epic battle to save his friend. ⚔️🔥',
                    'description' => 'In a climactic showdown, Raziel faces Gothel in a battle of wits and strength. With everything on the line, Raziel must summon all his courage and skills to defeat Gothel and free his friend, bringing his daring rescue mission to a thrilling conclusion. ⚔️🔥',
                    'trailer_url' => 'https://youtu.be/UwsbkXkEyOE?si=tNhFI_T6RWg77WNq',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '01:15',
                    'release_date' => '2021-07-09',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/iw_0KFjRY_Y?si=WjsPaMtnVjHO7x8N',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The Midnight Chase',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_midnight_chase_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_midnight_chase_thumb.png',
                    'entertainment_id' => 4,
                    'season_id' => 6,
                    'short_desc' => 'Detective Black tracks a vital lead through the dark city streets. 🌃🚔',
                    'description' => 'The Midnight Chase plunges viewers into a heart-pounding pursuit through the city. Detective Black, following a crucial lead, navigates the underbelly of the metropolis, facing danger at every turn. As he gets closer to uncovering The Phantom’s next move, the stakes grow higher, and the chase more perilous. 🌃🚔',
                    'trailer_url' => 'https://youtu.be/T5UokLYVJMI?si=7DVFmcXSmf5zVGKj',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:18',
                    'release_date' => '2022-08-05',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/DwXrfN_-GuE?si=v4uz4roJylb8w3tx',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Web of Deceit',
                    'poster_url' => '/dummy-images/episode/s1_e2_web_of_deceit_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_web_of_deceit_thumb.png',
                    'entertainment_id' => 4,
                    'season_id' => 6,
                    'short_desc' => 'A tangled web of lies puts Detective Black in grave danger. 🕸️⚠️',
                    'description' => 'In Web of Deceit, Detective Black uncovers a complex network of deception that threatens his mission. With allies turning into enemies and truth entwined with lies, he must tread carefully to avoid deadly traps. The episode is a thrilling exploration of trust, betrayal, and the relentless quest for justice. 🕸️⚠️',
                    'trailer_url' => 'https://youtu.be/T5UokLYVJMI?si=7DVFmcXSmf5zVGKj',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:10',
                    'release_date' => '2022-08-07',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/alT7IxwYd6U?si=hmf8B75acVelyLS3',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E1 Shadows in the Dark',
                    'poster_url' => '/dummy-images/episode/s2_e1_shadows_in_the_dark_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_shadows_in_the_dark_thumb.png',
                    'entertainment_id' => 4,
                    'season_id' => 7,
                    'short_desc' => 'Detective Black uncovers hidden clues in the darkest corners of the city. 🕵️‍♂️🌑',
                    'description' => 'In Shadows in the Dark, Detective Black ventures into the most dangerous and obscure parts of the city to uncover hidden clues that could lead to The Phantom. As he navigates through abandoned buildings and forgotten alleyways, he encounters unexpected allies and faces deadly ambushes. Each discovery brings him closer to understanding The Phantom\'s master plan, but the journey is fraught with peril and intrigue. 🕵️‍♂️🌑',
                    'trailer_url' => 'https://youtu.be/N5d16cUKqu0?si=xGfISG2Yw1ho9bzj',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:08',
                    'release_date' => '2022-08-09',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/EiHzphCFBqE?si=OfKTr8nEozYOd5wP',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The Haunted Arrival',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_haunted_arrival_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_haunted_arrival_thumb.png',
                    'entertainment_id' => 5,
                    'season_id' => 8,
                    'short_desc' => 'New residents experience eerie occurrences as they settle into their home. 🏚️👀',
                    'description' => 'In The Haunted Arrival, a new family moves into an old mansion in Ravenwood, unaware of the horrors that await them. Strange noises, ghostly apparitions, and unexplainable events soon plague their daily lives. As they seek help from locals, they begin to unravel the mansion\'s dark past and the malevolent spirit that resides within. 🏚️👀',
                    'trailer_url' => 'https://youtu.be/bX-PTsk0SPQ?si=joyPGPGvhXxxRi2o',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:08',
                    'release_date' => '2023-09-14',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/mPtCeemqdE0?si=vfZgZoBE4QPdlfp4',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Echoes of the Past',
                    'poster_url' => '/dummy-images/episode/s1_e2_echoes_of_the_past_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_echoes_of_the_past_thumb.png',
                    'entertainment_id' => 5,
                    'season_id' => 8,
                    'short_desc' => 'Residents uncover hidden secrets in an old diary that leads to terrifying revelations. 📖😱',
                    'description' => 'Echoes of the Past follows the residents as they find an old diary hidden in the mansion\'s attic. The diary reveals chilling accounts of previous inhabitants and the horrors they faced. As they read further, the current residents realize that the malevolent spirit is more powerful and dangerous than they imagined. With each page, the terror escalates, bringing them closer to the truth and deeper into danger. 📖😱',
                    'trailer_url' => 'https://youtu.be/V6wWKNij_1M?si=T0CX05U6pKcEyyOM',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:08',
                    'release_date' => '2023-09-15',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/2ODO6tIIzN0?si=2mobmPhb3V_vS58g',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 Whispers in the Shadows',
                    'poster_url' => '/dummy-images/episode/s1_e3_whispers_in_the_shadows_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_whispers_in_the_shadows_thumb.png',
                    'entertainment_id' => 5,
                    'season_id' => 8,
                    'short_desc' => 'Mysterious voices haunt the residents of Ravenwood, foretelling ominous events. 🗣️🌑',
                    'description' => 'Whispers in the Shadows explores the unsettling phenomenon plaguing Ravenwood\'s inhabitants as eerie voices echo through the town, hinting at dark and foreboding events to come. As paranoia grips the community and tensions rise, the residents must decipher the cryptic messages before they fall prey to the malevolent forces lurking in the shadows. The episode unravels layers of fear and intrigue, pushing the characters to confront their deepest fears in a race against time to uncover the truth behind the whispered omens. 🗣️🌑',
                    'trailer_url' => 'https://youtu.be/7FfGW-2dpx8?si=ed1gFGTajO5jkQ0t',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:08',
                    'release_date' => '2023-09-22',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/2ul2vOA39cU?si=jrg8Y0eur17V8A8r',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E1 The Return of Darkness',
                    'poster_url' => '/dummy-images/episode/s2_e1_the_return_of_darkness_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_the_return_of_darkness_thumb.png',
                    'entertainment_id' => 5,
                    'season_id' => 9,
                    'short_desc' => 'Dark forces grow stronger, and the town faces renewed terror. 🖤🕯️',
                    'description' => 'In The Return of Darkness, the malevolent forces in Ravenwood grow even stronger, casting a deeper shadow over the town. The residents, now aware of the historical curses, find themselves facing new and more terrifying manifestations. As they fight to protect their loved ones, they uncover more about the nature of the darkness that plagues their home. 🖤🕯️',
                    'trailer_url' => 'https://youtu.be/2X7G6p-oNG8?si=m0TREbT6RB_rppT_',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '05:08',
                    'release_date' => '2023-11-03',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/Bfdirk3dCew?si=MVE2OfPUWhjY7bQX',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E2 The Shadow\'s Grasp',
                    'poster_url' => '/dummy-images/episode/s2_e2_the_shadows_grasp_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e2_the_shadows_grasp_thumb.png',
                    'entertainment_id' => 5,
                    'season_id' => 9,
                    'short_desc' => 'The town\'s residents struggle against the encroaching darkness as secrets come to light. 🌑🖤',
                    'description' => 'In The Shadow\'s Grasp, the encroaching darkness begins to engulf Ravenwood, causing widespread fear and chaos. As the town\'s residents fight to survive, they uncover more secrets about the malevolent forces and their connection to the town\'s history. The episode highlights their desperate attempts to combat the evil while dealing with personal sacrifices and unexpected revelations. 🌑🖤',
                    'trailer_url' => 'https://youtu.be/IuqaXBFS0ug?si=Gz7n0cIeja5gCuOu',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '06:08',
                    'release_date' => '2023-11-10',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/9ZXFaaQJb0c?si=mErWWDpqEFzijyRA',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The Silent Witness',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_silent_witness_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_silent_witness_thumb.png',
                    'entertainment_id' => 6,
                    'season_id' => 10,
                    'short_desc' => 'Investigator Reed finds a crucial clue from an unexpected silent witness. 🕵️‍♂️🔎',
                    'description' => 'In The Silent Witness, Investigator Reed discovers a crucial clue from an unexpected source — a silent witness whose testimony could unravel the mystery. As he pieces together the information, he uncovers a pattern that points to a much larger conspiracy. The episode is filled with tension and the slow, deliberate uncovering of hidden truths. 🕵️‍♂️🔎',
                    'trailer_url' => 'https://youtu.be/em1ec7BZHJw?si=MSD31eT22XrZ7ohu',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'IMDb_rating' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-01-11',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/_2un1aU7mT0?si=Ztan6plG7Is5osDt',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Web of Lies',
                    'poster_url' => '/dummy-images/episode/s1_e2_web_of_lies_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_web_of_lies_thumb.png',
                    'entertainment_id' => 6,
                    'season_id' => 10,
                    'short_desc' => 'Reed navigates a tangled web of lies to find the truth behind a high-profile crime. 🕸️⚖️',
                    'description' => 'Web of Lies sees Investigator Reed diving deep into a complex network of deception surrounding a high-profile crime. As he navigates through false leads and deceitful informants, he gets closer to the truth, but also finds himself in greater danger. The episode is a thrilling exploration of the lengths people will go to keep their secrets hidden. 🕸️⚖️',
                    'trailer_url' => 'https://youtu.be/m1J8sqBex18?si=SqY0DIpLR7Lr13Sk',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 10,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-01-18',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/epVRE3nWWAg?si=pLxJXbcPhmIuLYe0',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 The Hidden Code',
                    'poster_url' => '/dummy-images/episode/s1_e3_the_hidden_code_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_the_hidden_code_thumb.png',
                    'entertainment_id' => 6,
                    'season_id' => 10,
                    'short_desc' => 'Reed deciphers a cryptic code that leads him closer to the heart of the conspiracy. 🔍🗝️',
                    'description' => 'In The Hidden Code, Investigator Reed discovers a cryptic code embedded in seemingly unrelated pieces of evidence. As he deciphers the code, it leads him closer to the heart of the conspiracy, revealing connections he never expected. The episode is a thrilling blend of puzzle-solving and suspense, as Reed races against time to stay ahead of those who would do anything to keep the secrets hidden. 🔍🗝️',
                    'trailer_url' => 'https://youtu.be/SjkcA2ZCmDU?si=F9hJLcsxVvJCfDta',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 10,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-01-25',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/-WzB5wqpkbg?si=snkkYmtcH9TuuUEb',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Echoes of the Emerald',
                    'poster_url' => '/dummy-images/episode/s1_e1_echoes_of_the_emerald_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_echoes_of_the_emerald_thumb.png',
                    'entertainment_id' => 7,
                    'season_id' => 11,
                    'short_desc' => 'Emily is drawn into Oz after receiving cryptic messages, discovering that her grandmother’s past is not just a story, but a nightmare waiting for her.',
                    'description' => 'Emily Gale receives mysterious messages linked to her grandmother’s past, leading her to a cursed book left behind by Dorothy. Curious yet fearful, she follows the clues, only to find herself trapped in a decaying version of Oz. There, she is haunted by visions of a once-great land, now overrun with dangerous shadows and monstrous creatures. As she struggles to understand her grandmother’s connection to the forgotten world, Emily realizes that her fate is intertwined with the horrors that now lurk within. 🌪️📜🖤',
                    'trailer_url' => 'https://youtu.be/7VXOHmaTd7g?si=Qjm-q92VPXnVG5NN',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-02-01',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/A5fBmZHgcT0?si=n8vuYfPWIsQCkMwg',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 The Curse Unveiled',
                    'poster_url' => '/dummy-images/episode/s1_e2_the_curse_unveiled_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_the_curse_unveiled_thumb.png',
                    'entertainment_id' => 7,
                    'season_id' => 11,
                    'short_desc' => 'Emily encounters a mysterious figure from her grandmother’s past, who reveals the true nature of the curse that haunts the Gale family.',
                    'description' => 'Emily comes face to face with a figure who claims to have fought alongside her grandmother, Dorothy, in a battle to contain the dark forces of Oz. This stranger reveals the shocking truth: Dorothy never truly defeated the evil lurking in Oz; she merely contained it. Now, with Dorothy gone, the evil has been unleashed again, and it is hungry for revenge. Emily learns that her journey is not just one of survival, but of destiny. As the darkness grows around her, Emily must decide whether to embrace her family’s legacy or fall victim to the curse. 🌑🔮🖋️',
                    'trailer_url' => 'https://youtu.be/H0u8yO9kiAA?si=V__ZIHm_Pu3yCqI8',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-02-08',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/7-Sy9azQIC8?si=fFrb5lgs0BTcLzs6',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E1 The Forgotten Kingdom',
                    'poster_url' => '/dummy-images/episode/s2_e1_the_forgotten_kingdom_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_the_forgotten_kingdom_thumb.png',
                    'entertainment_id' => 7,
                    'season_id' => 12,
                    'short_desc' => 'Emily stumbles upon the ruins of the Emerald City, where she faces her first true battle against the creatures of Oz and uncovers a shocking revelation about her grandmother.',
                    'description' => '"The Forgotten Kingdom" sees Emily journey deeper into the haunted lands of Oz, where she discovers the ruins of the once-glorious Emerald City. The streets are empty, and the city’s vibrant green glow has faded into a lifeless grey. As she explores the eerie remnants of the kingdom, Emily encounters dangerous creatures—twisted versions of the characters her grandmother once knew. In a harrowing battle, she is forced to rely on her instincts and newfound strength. Amid the chaos, Emily uncovers a hidden journal that reveals secrets about Dorothy’s time in Oz and the real reason behind the family curse. 🏰🌲⚔️',
                    'trailer_url' => 'https://youtu.be/PI4Z7t3AZ5E?si=QNKYohZ1ZgLol_OP',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-02-11',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/-I2mVPRZ2_c?si=rb2c2k8wXRepTp5v',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The New Moon',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_new_moon_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_new_moon_thumb.png',
                    'entertainment_id' => 8, // Replace with the appropriate ID
                    'season_id' => 13, // Replace with the appropriate season ID for Season 1
                    'short_desc' => '🌑 Maddy’s life takes a dramatic turn when she meets Rhydian, a boy with an unknown connection to her wolfblood pack.',
                    'description' => '🌑 Maddy, a confident young wolfblood, is used to keeping her secret hidden from the world. But everything changes when a new boy, Rhydian, arrives at her school. He smells like her pack, yet he’s completely unaware of his wolfblood nature. Suspicious and intrigued, Maddy decides to uncover his secrets, leading her into a world of danger she never expected. Will Rhydian accept his true identity, or will his rebellious streak threaten them both? 🐺⚔️',
                    'trailer_url' => 'https://youtu.be/MAFsRmx6pPo?si=CJjoeRbHVtKJt9oC',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 8,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-02-15',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/cYCcnV0YO1U?si=ZLrL3UVoHmf9JY4V',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Pack Bonds',
                    'poster_url' => '/dummy-images/episode/s1_e2_pack_bonds_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_pack_bonds_thumb.png',
                    'entertainment_id' => 8,
                    'season_id' => 13,
                    'short_desc' => '🐺 Rhydian struggles to come to terms with his new reality as Maddy tries to teach him the ways of the wolfbloods.',
                    'description' => '🐺 As Rhydian begins to process the truth about his wolfblood heritage, Maddy steps in to guide him through the transformation process. But things aren’t easy—Rhydian’s rebellious nature causes friction, and the dangers of exposure grow as strange happenings around town raise suspicion. With hunters lurking nearby, Maddy must help Rhydian quickly adapt, or they’ll both risk the safety of their pack. Bonds of trust will be tested, and survival depends on their ability to work together. 🌕🔥👣',
                    'trailer_url' => 'https://youtu.be/GKq7QlNz3CA?si=E6fnSD4CvpEPcMu7',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 10,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-02-15',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/2c1X2wmqxZs?si=-BhAYJvr_f8AUpGj',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Call of the Ancestors',
                    'poster_url' => '/dummy-images/episode/s1_e1_call_of_the_ancestors_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_call_of_the_ancestors_thumb.png',
                    'entertainment_id' => 9,
                    'season_id' => 14,
                    'short_desc' => '🌿 As invaders approach, tribal leaders must decide whether to unite or face destruction alone.',
                    'description' => '🌿 In the opening episode, the tribes are scattered and in disarray. When the threat of invaders looms on the horizon, ancient prophecies begin to unfold. A young warrior from the Mountain Tribe receives a vision from his ancestors, urging him to unite the tribes. However, distrust and rivalry run deep among the leaders. As the invaders draw nearer, the tribes must decide whether to join forces or perish alone. The episode sets the stage for the epic struggle ahead, filled with suspense, political intrigue, and the first hints of war. ⚔️🌄🔥',
                    'trailer_url' => 'https://youtu.be/iJkspWwwZLM?si=chtl8vdmLqPNKPfE',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:08',
                    'release_date' => '2024-02-20',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/VOwUgraDBFI?si=1IUq1nOWZzSogcE8',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Forging Alliances',
                    'poster_url' => '/dummy-images/episode/s1_e2_forging_alliances_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_forging_alliances_thumb.png',
                    'entertainment_id' => 9,
                    'season_id' => 14,
                    'short_desc' => 'Tribes unite to protect their sacred land from invaders, forging a timeless legacy of courage and unity. 🛡️🔥🌄',
                    'description' => 'Amidst the rugged terrain of ancient lands, many tribes rise against the threats that seek to desecrate their sacred homeland. As they fight to preserve their heritage, their bravery and unity carve an enduring legacy that will resonate through the ages. 🐺🌟⚔️',
                    'trailer_url' => 'https://youtu.be/6sxnOLRGkhw?si=WrBfEDVah3Z-vFwO',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 10,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:02',
                    'release_date' => '2024-02-21',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/o0OkTEK9KKs?si=BDW4TC4uDF7VluOz',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 The Final Watch',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_final_watch_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_final_watch_thumb.png',
                    'entertainment_id' => 10,
                    'season_id' => 15,
                    'short_desc' => 'During the Indo-Pak War, "The Final Watch" follows a sniper and his spotter grappling with moral dilemmas as they hunt their enemies amidst intense conflict. 🎯',
                    'description' => 'In "The Final Watch," set against the backdrop of the Indo-Pak War, a sniper and his spotter are embroiled in a moral struggle while navigating the battlefield. The film delves into the complexities of war, showcasing suspense, drama, and a hauntingly beautiful soundtrack that resonates with the film\'s themes of sacrifice and duty. 🎖️🔥',
                    'trailer_url' => 'https://youtu.be/QROfT5dT_yQ?si=jt4LxdBIIe5h7xY_',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-03-01',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/JEKCMP3w9zs?si=psaIC0wKC3akDOqp',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 The Silent Marksman',
                    'poster_url' => '/dummy-images/episode/s1_e2_the_silent_marksman_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_the_silent_marksman_thumb.png',
                    'entertainment_id' => 10,
                    'season_id' =>15,
                    'short_desc' => 'In "The Silent Marksman," a sniper and his spotter face a moral dilemma while hunting their enemies during the Indo-Pak War, set against a dramatic and suspenseful backdrop. 🎯',
                    'description' => 'The Silent Marksman follows a sniper and his spotter as they navigate the complexities of war during the Indo-Pak conflict. As they engage in high-stakes combat, they must confront their own moral questions and the harsh realities of their mission. With a gripping narrative and a poignant musical score, the film provides a deep exploration of duty and sacrifice. 🎖️💔',
                    'trailer_url' => 'https://youtu.be/s2-1hz1juBI?si=OG5eOFO6QnSfLiFb',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:45',
                    'release_date' => '2024-03-08',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/AWuxeDm1SGA?si=5rZ3rc4LnLYtmJ2u',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 Last Stand: Retreat of Valor',
                    'poster_url' => '/dummy-images/episode/s1_e3_last_stand_retreat_of_valor_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_last_stand_retreat_of_valor_thumb.png',
                    'entertainment_id' => 10,
                    'season_id' => 15,
                    'short_desc' => 'Abandoned by their retreating army, a group of soldiers makes a heroic last stand in the face of danger. 🛡️🔥',
                    'description' => 'Last Stand: Retreat of Valor follows a brave group of German soldiers who are left stranded after their army retreats. As they face betrayal, relentless enemies, and dwindling supplies, they must summon their inner strength and make their final stand in a war-torn battlefield. 🛡️🔥⚔️',
                    'trailer_url' => 'https://youtu.be/hf8EYbVxtCY?si=ayaY0YZtZu4seFnF',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'IMDb_rating' => 8,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:15',
                    'release_date' => '2024-03-15',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/PdxPlbKFkaM?si=H_nwgJKc4Ioqj1tR',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],[
                    'name' => 'S1 E1 The Battle of PT-76',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_battle_of_pt_76_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_battle_of_pt_76_thumb.png',
                    'entertainment_id' => 11,
                    'season_id' => 16,
                    'short_desc' => 'Captain Balram Singh Mehta’s heroic efforts with the Indian 45 Cavalry during the 1971 Indo-Pakistani War, leading the charge for Bangladesh’s independence. 🚩🌟',
                    'description' => 'The Battle of PT-76 tells the gripping story of Captain Balram Singh Mehta and his regiment as they engage in crucial battles during the 1971 Indo-Pakistani War. Named after the amphibious PT-76 tank, the film showcases Mehta’s rise to prominence as he navigates the trials of war and strives to secure Bangladesh\'s freedom. A tale of valor and dedication, underscoring a significant historical moment. 🏆🚀',
                    'trailer_url' => 'https://youtu.be/5dTtuN5BceI?si=rQukzFVuulLJY3K4',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '05:20',
                    'release_date' => '2024-03-16',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/vAp-9i4mFBQ?si=53kE_c6K8fftINMb',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Apocalypse Vault',
                    'poster_url' => '/dummy-images/episode/s1_e2_apocalypse_vault_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_apocalypse_vault_thumb.png',
                    'entertainment_id' => 11,
                    'season_id' => 16,
                    'short_desc' => 'A crew of mercenaries must pull off an impossible heist in a zombie-infested Las Vegas before the city is nuked. 🧟‍♂️🔥💵',
                    'description' => 'A group of elite thieves is tasked with infiltrating a walled-off, zombie-overrun Las Vegas to retrieve $200 million. With the clock ticking and deadly Alpha zombies closing in, this high-stakes mission becomes a race for survival. 🧟‍♂️🔥💣💵',
                    'trailer_url' => 'https://youtu.be/HHJkUQGm2H8?si=ciuK8Jd5Mp4vyHTe',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'pay-per-view',
                    'price' => 10,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '06:45',
                    'release_date' => '2024-03-17',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/iwA8ooWRNBs?si=JqXh28NIx2Dgk8aA',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E1 Depths of Discovery',
                    'poster_url' => '/dummy-images/episode/s1_e1_depths_of_discovery_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_depths_of_discovery_thumb.png',
                    'entertainment_id' => 12,
                    'season_id' => 17,
                    'short_desc' => 'The team descends into the Earth’s core, unveiling ancient secrets and battling unknown forces in their quest to unlock the mysteries of the planet\'s inner depths. 🌋🌪️',
                    'description' => 'A thrilling expedition into the Earth’s core unearths a dangerous, ancient world in this action-packed adventure. 🌍⚒️ In "Depths of Discovery," a scientist, his curious nephew, and an experienced mountain guide descend into the earth’s core on a daring mission to find his missing brother. What awaits them is an extraordinary world filled with prehistoric creatures, uncharted landscapes, and unknown dangers. Their journey turns into a heart-pounding adventure of survival and self-discovery. 🌍🦕⚒️',
                    'trailer_url' => 'https://youtu.be/rze8QYwWGMs?si=UQIYYM4LQtxLTILi',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:10',
                    'release_date' => '2024-04-13',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/M6h5AS971hY?si=T7Sf0Gjetp_7Ld2C',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Into the Earth\'s Core',
                    'poster_url' => '/dummy-images/episode/s1_e2_into_the_earths_core_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_into_the_earths_core_thumb.png',
                    'entertainment_id' => 12,
                    'season_id' => 17,
                    'short_desc' => 'A scientist and his companions uncover a dangerous lost world hidden beneath the Earth\'s surface, fighting to survive in an epic action-adventure. 🌋🦕',
                    'description' => 'Into the Earth\'s Core follows a group of explorers as they delve into the unknown in search of a missing brother. What begins as a scientific quest soon transforms into a perilous journey, where danger lurks around every corner and survival is far from guaranteed. Facing monstrous creatures and earth-shattering discoveries, they must push beyond their limits to make it back alive. 🌋⚠️🦖',
                    'trailer_url' => 'https://youtu.be/jzQn0-WH4WM?si=BLrfsFpVGzCttbRF',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:15',
                    'release_date' => '2024-04-14',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/gkBEd41mOIo?si=yItQlzbz60lijY9m',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Clash of Empires',
                    'poster_url' => '/dummy-images/episode/s1_e3_clash_of_empires_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_clash_of_empires_thumb.png',
                    'entertainment_id' => 12,
                    'season_id' => 17,
                    'short_desc' => 'Clash of Empires unfolds in a world torn apart by conflict between rival factions. The Alliance and Horde engage in a fierce struggle, with legendary warriors, powerful magic, and unstoppable armies driving the chaos. 🏰⚔️💥',
                    'description' => 'The ultimate battle for supremacy erupts as two powerful factions clash in a world-altering war. 🏰💥⚔️',
                    'trailer_url' => 'https://youtu.be/rFq52e7wYws?si=n4XnFfiHBI3pBko4',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:50',
                    'release_date' => '2024-04-15',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/AWuxeDm1SGA?si=5rZ3rc4LnLYtmJ2u',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Cutting Edge Chaos',
                    'poster_url' => '/dummy-images/episode/s1_e1_cutting_edge_chaos_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_cutting_edge_chaos_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 18,
                    'short_desc' => 'The Razor\'s Edge - A janitor-turned-barber accidentally stumbles into a world of espionage, where every haircut leads to explosive action. ✂️🕶️💣',
                    'description' => 'When an unsuspecting janitor, Jack, is mistaken for the new barber at an underground espionage hideout, he’s thrust into a whirlwind of high-octane action. Armed only with barber tools, Jack must fight off international spies and uncover hidden secrets, all while delivering the sharpest haircuts of his life. ✂️💣🕵️‍♂️💥',
                    'trailer_url' => 'https://youtu.be/hSxLUd8aly4?si=ishR_1RLpsgRm1R_',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 1,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '03:20',
                    'release_date' => '2024-04-28',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/OthBEy73VQ4?si=PdWE8bicX90lhHKb',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Snip & Strike',
                    'poster_url' => '/dummy-images/episode/s1_e2_snip_strike_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_snip_strike_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 18,
                    'short_desc' => 'A hairstylist becomes an unlikely hero as he battles criminals in a salon over a hidden microchip. Snips turn into strikes in this thrilling action adventure! ✂️🕶️⚔️',
                    'description' => 'Leo, a mild-mannered hairstylist, is forced to become a hero when a gang of criminals invade his salon, looking for a hidden microchip that could change the world. Using only his barber skills and quick wit, Leo must outsmart the villains and save the day, turning an ordinary haircut into a high-stakes showdown. ✂️💥💈🕵️‍♂️',
                    'trailer_url' => 'https://youtu.be/OxLQZVmKWEo?si=RYQIiu7LQpnSfdRf',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '03:28',
                    'release_date' => '2024-04-29',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/13FLawVtwSc?si=Wsdj4GsSHoCq0VsP',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 The Barber\'s Edge',
                    'poster_url' => '/dummy-images/episode/s1_e3_the_barbers_edge_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_the_barbers_edge_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 18,
                    'short_desc' => 'Mr. Cool must defend his barbershop and secret hair formula from enemy agents, using only his quirky charm and barber tools. ✂️💣💇‍♂️',
                    'description' => 'Mr. Cool is unwittingly caught in a conspiracy involving a top-secret hair formula hidden in his barbershop. Chaos ensues when rival agents and dangerous criminals come after him, forcing Bean to fight back using only barber tools and his incredible knack for slapstick combat. ✂️🕶️💣💇‍♂️',
                    'trailer_url' => 'https://youtu.be/-Qv6p6pTz5I?si=aeaLICb9s9VAgl4W',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:43',
                    'release_date' => '2024-04-30',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/QTli1HU9axY?si=wgvnUQBuY2rVXJn0',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E4 Cut to the Chase',
                    'poster_url' => '/dummy-images/episode/s1_e4_cut_to_the_chase_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_cut_to_the_chase_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 18,
                    'short_desc' => 'Mr. Bean\'s bad haircut turns into a wild chase as he accidentally gets involved in a spy mission, running from both criminals and the law! ✂️🚗🔥',
                    'description' => 'Cut to the Chase sees Mr. Bean accidentally tangled in an international spy ring when a client he gives a terrible haircut to turns out to be a wanted criminal. Now, with both criminals and law enforcement after him, Bean must dodge bullets and hair clippers as he races through the city in his Mini, turning every barber shop into a battleground. 🚗✂️🕶️🔥',
                    'trailer_url' => 'https://youtu.be/dKkT8_RGDYg?si=4gdepK-sTlGcxcPw',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '03:08',
                    'release_date' => '2024-05-01',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/kSGrk5gVkmM?si=YJbvb2tBrC490XKe',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S2 E1 Blade Runner: Salon Showdown',
                    'poster_url' => '/dummy-images/episode/s2_e1_blade_runner_salon_showdown_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e1_blade_runner_salon_showdown_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 19,
                    'short_desc' => 'Ethan, a former special ops agent turned barber, is pulled back into action when his old nemesis resurfaces, targeting his salon as the front for a dangerous arms deal. 💈✂️💥🕵️‍♂️',
                    'description' => 'A retired special ops agent turned barber must fend off a criminal syndicate using only his skills and tools in an epic salon showdown. ✂️💣💈',
                    'trailer_url' => 'https://youtu.be/7mT8El4mBVw?si=QURW5DdZ0HMm1wOm',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '03:20',
                    'release_date' => '2024-05-02',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/FG3ohfDASao?si=urEsRJhkQmg5YDI4',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S2 E2 Lens Lunacy: The Great Camera Caper',
                    'poster_url' => '/dummy-images/episode/s2_e2_lens_lunacy_the_great_camera_caper_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s2_e2_lens_lunacy_the_great_camera_caper_thumb.png',
                    'entertainment_id' => 13,
                    'season_id' => 19,
                    'short_desc' => 'When a beloved camera goes missing, a well-meaning but hapless amateur sleuth takes on the challenge of finding it. With a mix of slapstick humor and endearing blunders, he navigates through a series of comedic escapades, learning that sometimes laughter is the best tool for solving a mystery. 📸🎭🔎',
                    'description' => 'A bumbling detective’s quest to recover his stolen camera turns into a comedy of errors and mishaps. 📷😂🕵️‍♂️',
                    'trailer_url' => 'https://youtu.be/eH7EyPs_Va8?si=BRcgB15dMbdoEj7G',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '04:15',
                    'release_date' => '2024-05-03',
                    'is_restricted' => true,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/UD-22FD3GQo?si=ROszF3zF7jHwcBgb',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Waves of the Past',
                    'poster_url' => '/dummy-images/episode/s1_e1_waves_of_the_past_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_waves_of_the_past_thumb.png',
                    'entertainment_id' => 14,
                    'season_id' => 20,
                    'short_desc' => 'A legendary football star confronts his past mistakes while teaching a group of kids the fundamentals of baseball. As he learns from their determination, he starts to see life in a new light. ⚾🏆🌊',
                    'description' => 'In "Waves of the Past", the star athlete, once a pro football legend, takes on the daunting task of coaching a ragtag team of kids in baseball. With little experience in the sport, he struggles to connect with the kids, haunted by his own past failures. As the children begin to open up to him, the waves of his past mistakes start to surface, pushing him to face the life lessons he’s avoided for years. In teaching the kids how to win on the field, he learns valuable lessons on how to find redemption and inner strength. ⚾🏆🌊',
                    'trailer_url' => 'https://youtu.be/xqzR_h3_84c?si=bpYToPY4e4uZ76oV',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '06:45',
                    'release_date' => '2024-05-02',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/XbP-Mc1RDEg?si=RFJqHSXMUkvCfmnZ',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Pit Stops and Breakdowns',
                    'poster_url' => '/dummy-images/episode/s1_e2_pit_stops_and_breakdowns_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_pit_stops_and_breakdowns_thumb.png',
                    'entertainment_id' => 14,
                    'season_id' => 20,
                    'short_desc' => 'After a tough start, the coach faces new challenges both on and off the field. When things fall apart, the kids teach him that the journey is just as important as the destination. 🛠️⚾🛑',
                    'description' => 'In "Pit Stops and Breakdowns", the coach’s frustration reaches a breaking point as the baseball team faces multiple setbacks during their early training sessions. Off the field, his personal life begins to unravel, mirroring the chaos on the diamond. The kids, however, show him that perseverance, even through small pit stops and breakdowns, is the key to success. Through their humor and resilience, the coach starts to realize that life, much like the game, is about bouncing back from mistakes and enjoying the ride, not just focusing on the final score. 🛠️⚾🛑',
                    'trailer_url' => 'https://youtu.be/pRH5u5lpArQ?si=ld4xRo9ELtLQXzbN',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => null,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:10',
                    'release_date' => '2024-05-04',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/F2nO-6mzCF8?si=V3pk2XavKdRQSa5Z',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 Bridges and Boundaries',
                    'poster_url' => '/dummy-images/episode/s1_e3_bridges_and_boundaries_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_bridges_and_boundaries_thumb.png',
                    'entertainment_id' => 14,
                    'season_id' => 20,
                    'short_desc' => 'As relationships grow, the coach struggles with setting boundaries while building emotional bridges with the kids. Their bond becomes the key to success both on and off the field. 🌉⚾❤️',
                    'description' => 'In "Bridges and Boundaries", the coach finds himself balancing the growing bond between himself and the kids, while still trying to keep professional boundaries. As the team begins to show progress, personal conflicts arise, forcing the coach to question how deeply he should involve himself in their lives. Through moments of tension and heartfelt revelations, he begins to build emotional bridges with the kids, discovering that strong relationships are the foundation of success, whether in sports or in life. As the team starts to come together, so does the coach’s understanding of what it means to truly lead and inspire. 🌉⚾❤️',
                    'trailer_url' => 'https://youtu.be/5eQKOr6sFgk?si=aGYzXoiBPFTf1XtA',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:15',
                    'release_date' => '2024-05-06',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/nohSnrV2CgE?si=6HiPnf176gJ9VNdm',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Grandpa\'s Hectic Heirlooms',
                    'poster_url' => '/dummy-images/episode/s1_e1_grandpas_hectic_heirlooms_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_grandpas_hectic_heirlooms_thumb.png',
                    'entertainment_id' => 15,
                    'season_id' => 21,
                    'short_desc' => 'A wealthy man’s glamorous life turns chaotic with the arrival of his six lively grandchildren, leading to hilarious lessons in family values. 👴👨‍👩‍👧‍👦🤣',
                    'description' => 'David McDoll’s posh life hits a comedic snag when he inherits six energetic grandchildren. His once-perfect world is thrown into delightful chaos as the kids upend his lavish lifestyle. Amidst the laughter and mayhem, David discovers the joys of family life and the value of putting loved ones first. 👴🎢🏡😂',
                    'trailer_url' => 'https://youtu.be/mJ_Tex6KT6w?si=0bhjIh5zYTZlk9EU',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-06-21',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/4hA2ZuK5axU?si=0koN4EoSNXUXaXaH',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Chaos at the McDoll Mansion',
                    'poster_url' => '/dummy-images/episode/s1_e2_chaos_at_the_mcdoll_mansion_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_chaos_at_the_mcdoll_mansion_thumb.png',
                    'entertainment_id' => 15,
                    'season_id' => 21,
                    'short_desc' => 'A wealthy man’s life is hilariously transformed when his six grandkids turn his mansion into a comedic playground, teaching him the true meaning of family. 🏰👨‍👩‍👧‍👦😂',
                    'description' => 'David McDoll’s opulent world is turned upside down when his six spirited grandchildren move in. From fancy cars to family feuds, the mansion becomes a whirlwind of laughter and mishaps. David’s journey from a self-absorbed tycoon to a loving grandfather is packed with humor and heart. 🏰👶🚗😂',
                    'trailer_url' => 'https://youtu.be/bgeRUptdlqU?si=xylQNW3eZdIDQ-_Y',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-06-22',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/X0K5cA2hS6g?si=dCiATYDWrJmKK86q',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E3 Grandpa\'s Wild Ride',
                    'poster_url' => '/dummy-images/episode/s1_e3_grandpas_wild_ride_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_grandpas_wild_ride_thumb.png',
                    'entertainment_id' => 15,
                    'season_id' => 21,
                    'short_desc' => 'Jason Kelly’s meticulously planned life takes a hilarious detour when he’s roped into driving his rambunctious grandfather, Dick, to Daytona Beach. What starts as a routine trip becomes a wild adventure full of raucous parties, unexpected encounters, and karaoke chaos. 🚗🎉🎤',
                    'description' => 'A straight-laced groom-to-be finds his life upended by his wild grandfather’s outrageous spring break escapades, leading to a comedy-filled journey of discovery and family bonding. 🚗😂🎉',
                    'trailer_url' => 'https://youtu.be/skl7gYRZHwE?si=kiekCHcihmEJH54D',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-06-23',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/D7vcG9bHtJI?si=ndF6thZ6eEMZ79-v',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E4 Funeral Frenzy',
                    'poster_url' => '/dummy-images/episode/s1_e4_funeral_frenzy_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_funeral_frenzy_thumb.png',
                    'entertainment_id' => 15,
                    'season_id' => 21,
                    'short_desc' => 'A family patriarch\'s doorstep death turns into a hilarious fiasco. Amid old family feuds and a well-meaning paramedic\'s attempts to help, the funeral becomes a comedy of errors and misunderstandings, leaving everyone in stitches. 💔🚨😂',
                    'description' => 'Funeral Frenzy kicks off with the sudden death of the estranged Jones family patriarch right on their doorstep. As a well-intentioned paramedic tries to assist, he finds himself in the midst of a whirlwind of old family feuds and unresolved conflicts. The funeral turns into a series of hilarious escapades and mishaps as the family grapples with their differences and attempts to navigate through the chaos. Prepare for a comedy of errors and family revelations that will leave everyone in stitches! 💔🎩🚨😂',
                    'trailer_url' => 'https://youtu.be/0Ji6i79LiL8?si=IIG3-D6Jl72oJq0_',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-06-24',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/JAoR9u85DQ0?si=JggaatJIEG5HxlOm',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Beneath the Mask',
                    'poster_url' => '/dummy-images/episode/s1_e1_beneath_the_mask_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_beneath_the_mask_thumb.png',
                    'entertainment_id' => 16,
                    'season_id' => 22,
                    'short_desc' => 'The journalist uncovers startling truths about the model’s hidden life, forcing both to confront the barriers they’ve built around their hearts. 🖤💔',
                    'description' => 'In "Beneath the Mask", the walls of secrecy start to crumble as the journalist begins to piece together the model’s hidden past. What starts as a lighthearted romance quickly deepens into something far more complex when he learns that her seemingly glamorous life is filled with shadows and secrets. As they both struggle to maintain their facades, their growing connection forces them to confront the emotional masks they’ve been wearing. Vulnerability, fear, and longing come to the forefront in this pivotal episode, as they realize that love requires more than attraction—it demands honesty and trust. Will they be brave enough to reveal their true selves, or will their hidden lives tear them apart? 🖤💔🌹',
                    'trailer_url' => 'https://youtu.be/WTLgg8oRSBE?si=SDS3_CB0MY1zNzko',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '05:20',
                    'release_date' => '2024-07-10',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/lYyPmA_nuDE?si=aMi1KgykEpC9KDEf',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Veil of Deception',
                    'poster_url' => '/dummy-images/episode/s1_e2_veil_of_deception_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_veil_of_deception_thumb.png',
                    'entertainment_id' => 16,
                    'season_id' => 22,
                    'short_desc' => 'The journalist’s pursuit of truth puts him on a collision course with the model’s double life, where love and betrayal walk a fine line. 💔🕵️‍♂️',
                    'description' => 'The stakes rise as the journalist delves deeper into the model’s mysterious past, uncovering secrets that threaten to shatter the fragile bond they’ve built. As he gets closer to the truth, the model\'s carefully constructed facade begins to unravel, revealing hidden motives and unexpected connections. Torn between his desire for the woman he’s grown to care for and his instinct to expose the truth, the journalist must decide if love is worth the risk of betrayal. This episode explores the tension between trust and deceit, as both characters struggle to protect their hearts from the fallout of a love built on lies. 💔🕵️‍♂️🌹',
                    'trailer_url' => 'https://youtu.be/2vrTz4kC6Ls?si=jzIQOzSIoExlyheH',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '06:45',
                    'release_date' => '2024-07-10',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/M1J-uv6oNYg?si=_3Auidh-lwrk5ll2',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Whispers of Her World',
                    'poster_url' => '/dummy-images/episode/s1_e3_whispers_of_her_world_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_whispers_of_her_world_thumb.png',
                    'entertainment_id' => 16,
                    'season_id' => 22,
                    'short_desc' => 'A smooth-talking journalist is shaken when a mysterious model with a secret life opens his heart, challenging him to rethink everything he believed about love.',
                    'description' => 'A well-known womanizer who’s used to fast romances. But when he meets a beautiful model leading a double life, his world is turned upside down. Her enigma draws him in, making him reflect on his own life and what truly matters. As they unravel each other’s truths, love takes center stage in a story of redemption and transformation. 💑🎭💫',
                    'trailer_url' => 'https://youtu.be/zF9YIYc0d7w?si=qy32xEf0hsJD9jyz',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:10',
                    'release_date' => '2024-07-17',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/rzR3KkzKwCY?si=jJN2ZFJz2afzdeqa',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E4 Double Hearts',
                    'poster_url' => '/dummy-images/episode/s1_e4_double_hearts_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_double_hearts_thumb.png',
                    'entertainment_id' => 16,
                    'season_id' => 22,
                    'short_desc' => 'A charming celebrity journalist known for his carefree lifestyle is swept off his feet by a mysterious model. As he uncovers her secret double life, he begins to question his own choices, discovering that love may be more than just a fleeting moment. ✨💑',
                    'description' => '“Double Hearts” tells the story of a celebrity journalist with a reputation for being a womanizer. His life takes an unexpected turn when he falls for a captivating model, only to learn she leads a double life filled with secrets. As their relationship deepens, he finds himself reevaluating his past decisions and confronting his feelings in a way he never expected. In this romantic journey of self-discovery, love proves to be more complex than he ever imagined. 🌹✨💑',
                    'trailer_url' => 'https://youtu.be/l3P2vrcKiXs?si=PG6Yj6Bff7KrDaeB',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:15',
                    'release_date' => '2024-07-17',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/H6UjfiD1iZs?si=V092vd-AZko1XB3N',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Echoes of Guilt',
                    'poster_url' => '/dummy-images/episode/s1_e1_echoes_of_guilt_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_echoes_of_guilt_thumb.png',
                    'entertainment_id' => 17,
                    'season_id' => 23,
                    'short_desc' => 'Father James returns to Blackthorn Manor, where the memories of the tragic suicide resurface, and the first eerie signs of paranormal activity begin to haunt him. 👻⛪',
                    'description' => 'In the series opener, "Echoes of Guilt," Father James is drawn back to Blackthorn Manor after months of avoiding it. The dilapidated mansion brings back painful memories of the young girl he failed to save. As night falls, unsettling occurrences begin to unfold—whispers in the dark, shadowy figures, and chilling cold spots. James questions whether he’s losing his mind or if the spirits of the girl and her stepfather are indeed lurking in the shadows. The tension builds as he starts to sense a supernatural presence watching him, setting the stage for the terror that’s about to be unleashed. 👻🏚️🩸',
                    'trailer_url' => 'https://youtu.be/O9i2vmFhSSY?si=YYmzH5_dw63-BeNU',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-08-12',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/HvZKVGFVT5A?si=vAazBlRh1t_rhCK0',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 The Stepfather’s Revenge',
                    'poster_url' => '/dummy-images/episode/s1_e2_the_stepfathers_revenge_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_the_stepfathers_revenge_thumb.png',
                    'entertainment_id' => 17,
                    'season_id' => 23,
                    'short_desc' => 'As the night deepens, Father James encounters the vengeful spirit of the stepfather, who begins to reveal dark secrets about the girl’s death and demands justice. 💀⚰️',
                    'description' => 'In "The Stepfather’s Revenge," Father James is confronted by the spirit of the girl’s violent stepfather, who accuses him of being complicit in her death. The ghostly figure torments James with cryptic messages, unsettling visions, and violent outbursts. The priest must piece together the sinister truth about the stepfather’s role in the tragedy, all while enduring terrifying hauntings that blur the line between reality and the supernatural. As the horrors escalate, James starts to unravel emotionally, grappling with his responsibility and the malevolent forces that now surround him. 🕯️💀👻',
                    'trailer_url' => 'https://youtu.be/hJo91wpGrz8?si=uVKgkkeEcNQjnp1r',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 4,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:08',
                    'release_date' => '2024-08-19',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/jwErAY9QjMA?si=WE3i0QOSQ7BBfe5b',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Night of the Damned',
                    'poster_url' => '/dummy-images/episode/s1_e3_night_of_the_damned_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_night_of_the_damned_thumb.png',
                    'entertainment_id' => 17,
                    'season_id' => 23,
                    'short_desc' => 'Father James faces the full wrath of the spirits in a climactic battle for his life and soul, as the mansion reveals its final horrifying secrets. 🔥🩸',
                    'description' => 'In "Night of the Damned," Father James’ ordeal reaches its terrifying peak. The spirits of the girl and her stepfather become increasingly violent, unleashing supernatural chaos that threatens to consume the priest. As James fights to survive, the truth about what really happened in Blackthorn Manor is revealed in a shocking twist. The priest is forced to confront not only the spirits but his own guilt, as the lines between redemption and damnation blur. With the dawn fast approaching, James must find a way to escape the haunted mansion—or be trapped there forever. 💀🏚️🔥',
                    'trailer_url' => 'https://youtu.be/rZQQbtK8wHk?si=EzoFuBhf2hR7LDcG',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'paid',
                    'plan_id' => 1,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-08-26',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/nujakIrBDCU?si=cXGG42k3lquWC2It',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E1 The Blackness Project',
                    'poster_url' => '/dummy-images/episode/s1_e1_the_blackness_project_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_the_blackness_project_thumb.png',
                    'entertainment_id' => 18,
                    'season_id' => 24,
                    'short_desc' => 'The main character starts his journey to reconnect with his African American roots, but his well-meaning white best friend’s ideas about culture lead to hilarious missteps. 🏫🎭',
                    'description' => 'In "The Blackness Project," the main character embarks on his quest to understand his African American heritage, starting with simple research into his cultural roots. His white best friend eagerly offers advice, but their attempts to engage with black culture lead to a series of funny and awkward encounters. From cultural festivals to botched conversations, their journey quickly turns into a comedic exploration of identity, misunderstandings, and unexpected revelations. Amidst the laughter, both friends begin to realize that finding one\'s cultural roots is far more complex—and amusing—than they ever imagined. 🌍🎉',
                    'trailer_url' => 'https://youtu.be/pCMHc-IFAB0?si=vIVQzT73CoPjbEio',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '06:45',
                    'release_date' => '2024-09-05',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/DJ0_rhsljpc?si=6KwFhULBBgZ0mKEG',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E2 Roots and Revelations',
                    'poster_url' => '/dummy-images/episode/s1_e2_roots_and_revelations_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_roots_and_revelations_thumb.png',
                    'entertainment_id' => 18,
                    'season_id' => 24,
                    'short_desc' => 'The families finally meet, leading to a clash of perspectives as the main character’s white liberal family and African American relatives attempt to connect, creating comedic tensions. 👪🎭',
                    'description' => 'The main character’s worlds collide as his white adoptive family and African American relatives come together for the first time. What starts as a well-intentioned family gathering quickly spirals into chaos as differing viewpoints, cultural misunderstandings, and personal quirks lead to a series of comical mishaps. From awkward cultural references to unintentional faux pas, both families struggle to connect, making the main character question his place within both. The episode is a laugh-out-loud exploration of what happens when two families, with vastly different cultural backgrounds, attempt to come together under one roof. 🎉👫',
                    'trailer_url' => 'https://youtu.be/eazggD_i7T0?si=6Gm4KeZo4sO2kP8b',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:10',
                    'release_date' => '2024-09-12',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/gchPb1y3iMM?si=M1NGoZ7pbFDNTgK3',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Family Fusion Frenzy',
                    'poster_url' => '/dummy-images/episode/s1_e3_family_fusion_frenzy_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_family_fusion_frenzy_thumb.png',
                    'entertainment_id' => 18,
                    'season_id' => 24,
                    'short_desc' => 'In this episode, the best friends take on an ambitious cultural project that goes hilariously wrong, bringing both families into the mix for a chaotic but heartwarming conclusion. 💥😂',
                    'description' => 'The main character and his best friend decide to create a cultural project aimed at bringing both their families together. However, things quickly go awry as their overly ambitious ideas result in humorous disasters. From a mishandled food fusion experiment to a poorly planned family talent show, the duo\'s well-meaning efforts only heighten the chaos. The episode brings all the characters together in a whirlwind of laughter, with each family member’s quirks adding to the madness. By the end of the episode, amidst the chaos and confusion, the families share a moment of understanding and connection, realizing that despite their differences, they can laugh—and learn—together. 🎭👪',
                    'trailer_url' => 'https://youtu.be/7lSzGK5HR1M?si=ltOK7kx6m3IIWv2b',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '04:15',
                    'release_date' => '2024-09-19',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/qcP2BpG4Ido?si=egp_pGrIpPMi51kH',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Haunted Harmony and Sleepwalking Antics',
                    'poster_url' => '/dummy-images/episode/s1_e1_haunted_harmony_and_sleepwalking_antics_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_haunted_harmony_and_sleepwalking_antics_thumb.png',
                    'entertainment_id' => 19,
                    'season_id' => 25,
                    'short_desc' => 'When a group of friends unintentionally awakens an ancient evil, eerie harmonies and bizarre sleepwalking incidents begin to plague their lives. As the horrors intensify, the group struggles to grasp the full extent of the terror they’ve unleashed. 👻🎶',
                    'description' => 'The group of young adults stumbles upon the cursed Necronomicon while exploring an old, abandoned mansion. Their discovery unknowingly awakens ancient, flesh-hungry demons that begin to haunt their lives in strange and terrifying ways. What starts as harmless sleepwalking and strange harmonies soon escalates into supernatural chaos. As each member of the group experiences bizarre incidents, they realize something far more sinister is lurking in the shadows. The once-peaceful atmosphere of their lives turns into a horrifying nightmare as they confront the first signs of the demonic presence they’ve unleashed. 😨📖🎵',
                    'trailer_url' => 'https://youtu.be/2X7G6p-oNG8?si=Y2MRnmG1oRRQI0yV',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-09-26',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/CasA8WERLo8?si=B16VsXQTnRwn2vcc',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Ghostly Giggles and Sleepwalking Shenanigans',
                    'poster_url' => '/dummy-images/episode/s1_e2_ghostly_giggles_and_sleepwalking_shenanigans_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_ghostly_giggles_and_sleepwalking_shenanigans_thumb.png',
                    'entertainment_id' => 19,
                    'season_id' => 25,
                    'short_desc' => 'A seemingly harmless sleepwalking incident spirals into chaos as the awakened demons begin to manipulate the group’s every move, using ghostly tricks to break their spirits. 🎭👹',
                    'description' => 'After the strange events of the previous episode, the group is further tormented by sleepwalking pranks and eerie ghostly laughter that echo throughout their surroundings. The demons, now unleashed, toy with the group’s fears and insecurities, slowly breaking their mental resolve. As the sleepwalking escalates into dangerous actions, the group begins to lose control, realizing that the demonic forces are manipulating them from within. Every corner they turn, they are met with chilling laughter and ghostly pranks that remind them of the horrifying evil they’ve awakened. As the group struggles to maintain their sanity, their bond begins to crack under the relentless pressure. 👻🎶😱',
                    'trailer_url' => 'https://youtu.be/smTK_AeAPHs?si=_DHZCV-kD4mjwIKd',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-10-01',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/FZAafmCPSjs?si=9G_CjrZlb3vwFPTC',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Sleepwalker Shenanigans and Ghostly Giggles',
                    'poster_url' => '/dummy-images/episode/s1_e3_sleepwalker_shenanigans_and_ghostly_giggles_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_sleepwalker_shenanigans_and_ghostly_giggles_thumb.png',
                    'entertainment_id' => 19,
                    'season_id' => 25,
                    'short_desc' => 'The demonic forces step up their game, using nightmarish sleepwalking to pit the group against each other in a series of terrifying and deadly pranks. 👻🕵️‍♂️',
                    'description' => 'The group is plunged deeper into chaos as the demons grow stronger, amplifying their control over the friends\' subconscious minds. Sleepwalking becomes a terrifying tool used by the demons to turn the group against one another. With every prank, the lines between reality and the supernatural blur, causing mistrust and paranoia to fester. The group’s attempts to break the demonic curse are foiled by increasingly dangerous antics orchestrated by the demons, who delight in their suffering. As friendships begin to fracture, the group is pushed to its limits, realizing that they are no longer just fighting supernatural forces—they are fighting for their lives. 👹🎭🔪',
                    'trailer_url' => 'https://youtu.be/Jxq13WJxLDY?si=AjKX1zULDPQ-Lqiw',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 1,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-10-05',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/SX1LiKN4ZcQ?si=6uJZt7OGt6EUzHD_',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E4 Haunting Beneath the Luck',
                    'poster_url' => '/dummy-images/episode/s1_e4_haunting_beneath_the_luck_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_haunting_beneath_the_luck_thumb.png',
                    'entertainment_id' => 19,
                    'season_id' => 25,
                    'short_desc' => 'A string of unexpected fortune hides a sinister secret as the group uncovers the dark truth behind the curse, forcing them to confront the demons head-on. 🕵️‍♀️👻',
                    'description' => 'In this chilling episode, the group experiences a bizarre twist in their fortunes—everything seems to suddenly go their way, but beneath the surface lies a terrifying truth. The demonic forces, now fully unleashed, offer the group moments of false hope, lulling them into a sense of security. However, this “luck” is nothing more than a twisted game. As they delve deeper into the mystery, the group uncovers the haunting connection between their newfound luck and the vengeful spirits they’ve awakened. With time running out and the true nature of the curse revealed, the group must face the horrifying reality of the demons’ endgame. What started as a seemingly harmless discovery has turned into a fight for their souls. 😨🍀👹',
                    'trailer_url' => 'https://youtu.be/bhYh4_FWxNo?si=UGh5bJqr6gta9Nhb',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-10-15',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/gmO2_FcfhgY?si=eu8bv_GcLKxlkXrs',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],
                [
                    'name' => 'S1 E1 Crimson Divide',
                    'poster_url' => '/dummy-images/episode/s1_e1_crimson_divide_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e1_crimson_divide_thumb.png',
                    'entertainment_id' => 20,
                    'season_id' => 26,
                    'short_desc' => 'The reunion starts with joy, but eerie signs in the wilderness begin to unsettle the group, hinting at something sinister watching them from the shadows. 😨🌲',
                    'description' => 'The four friends—Esme, Hannah, Ben, and Shan—arrive at the remote cabin for their long-awaited reunion. At first, everything seems perfect: laughter, memories, and the beauty of the wilderness. However, subtle signs of danger emerge as strange noises, shadows in the forest, and unsettling feelings creep in. What starts as a fun getaway quickly turns into a night filled with dread. Tensions rise as the group senses that something is wrong, setting the stage for the escalating horror to come. 🌑👀',
                    'trailer_url' => 'https://youtu.be/HO4uLABrIuc?si=_JUkCi82TFa6KaVT',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 6,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-10-16',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/AmpLWp_9YtU?si=CfCfsRUnffhTZSgL',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E2 Torn Horizons',
                    'poster_url' => '/dummy-images/episode/s1_e2_torn_horizons_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e2_torn_horizons_thumb.png',
                    'entertainment_id' => 20,
                    'season_id' => 26,
                    'short_desc' => 'As the group struggles to make sense of the strange occurrences, secrets from their pasts begin to surface, tearing them apart emotionally while the threat outside intensifies. 💥🌳',
                    'description' => 'In Torn Horizons, the group’s unity is tested as old wounds reopen, revealing the complicated history between the friends. Meanwhile, the eerie happenings grow more aggressive, with cryptic messages and terrifying encounters in the woods. Esme and Hannah find themselves at odds as they face their unresolved issues, while Ben and Shan uncover a clue that suggests they may not be the first visitors to fall victim to the mysterious force in the wilderness. The physical and emotional divide between them widens as they race to survive, leading to explosive confrontations and deepening suspense. 🔥🕵️‍♀️',
                    'trailer_url' => 'https://youtu.be/pAxGJfEYuJI?si=usPEgPrVvANZVl8F',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 3,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:20',
                    'release_date' => '2024-10-17',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/h-Y77SQeMD4?si=OMij7ddBHRDtKwgz',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E3 Fading Light',
                    'poster_url' => '/dummy-images/episode/s1_e3_fading_light_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e3_fading_light_thumb.png',
                    'entertainment_id' => 20,
                    'season_id' => 26,
                    'short_desc' => 'With nightfall approaching and the danger closing in, the group’s hope dwindles. Desperation takes hold as they struggle to find a way out of the woods. 🌒⚔️',
                    'description' => 'As night falls in Fading Light, the group’s fear intensifies, and they realize that their chances of survival are growing slimmer. With their escape route cut off and the presence in the woods becoming more menacing, Esme and her friends face their darkest hour. They begin to understand that they are not just being hunted but manipulated by an unseen force. As paranoia grows, the friends turn on each other, unsure of who they can trust. The chilling atmosphere of the episode creates a sense of inescapable dread, as the group struggles to find light—both literal and metaphorical—in the enveloping darkness. 🕯️🌘',
                    'trailer_url' => 'https://youtu.be/FXOtkvx25gI?si=iD3LrO0BIQv7Fz4d',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'IMDb_rating' => 7,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:28',
                    'release_date' => '2024-10-18',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/nujakIrBDCU?si=cXGG42k3lquWC2It',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

                [
                    'name' => 'S1 E4 Silent Betrayal',
                    'poster_url' => '/dummy-images/episode/s1_e4_silent_betrayal_thumb.png',
                    'poster_tv_url' => '/dummy-images/episode/s1_e4_silent_betrayal_thumb.png',
                    'entertainment_id' => 12, // Replace with the appropriate ID
                    'season_id' => 1, // Replace with the appropriate season ID for Season 1
                    'short_desc' => 'A shocking betrayal comes to light, fracturing the group as they face the ultimate confrontation with the malevolent force in the woods. 😱💔',
                    'description' => 'In the intense finale, Silent Betrayal, the group’s fragile trust is shattered when a long-buried secret is revealed. This revelation causes chaos among the friends, just as they are forced to confront the malevolent entity that has been haunting them. Esme takes charge as they prepare for the final showdown, but the betrayal weighs heavily on her. With their friendship in tatters, the group must decide whether to stand together or let the darkness consume them. As the true nature of the evil in the woods is unveiled, they face a deadly choice: fight for their lives or fall prey to the horrors lurking in the shadows. 🔪🌲',
                    'trailer_url' => 'https://youtu.be/7EzpvriIQ3I?si=32wWLtYpLoOf7QuP',
                    'trailer_url_type' => 'YouTube',
                    'access' => 'free',
                    'status' => 1,
                    'IMDb_rating' => 8,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:43',
                    'release_date' => '2024-10-19',
                    'is_restricted' => false,
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/BrDKY3RRg-g?si=SJgkbOqPdgCZCCOs',
                    'download_status' => false,
                    'download_type' => null,
                    'download_url' => null,
                    'enable_download_quality' => false,
                    'enable_quality' => false,
                ],

            ];

            if (env('IS_DUMMY_DATA')) {
                $episodeCounts = [];

                foreach ($episodes as $mediaData) {
                    $posterPath = $mediaData['poster_url'] ?? null;
                    $posterTvPath = $mediaData['poster_tv_url'] ?? null;

                    $mediaData['slug'] = Str::slug($mediaData['name']);

                    // Auto-assign episode_number sequentially within each season
                    $seasonId = $mediaData['season_id'] ?? null;
                    if ($seasonId) {
                        $episodeCounts[$seasonId] = ($episodeCounts[$seasonId] ?? 0) + 1;
                        $mediaData['episode_number'] = $episodeCounts[$seasonId];
                    }

                    $media = Episode::create(Arr::except($mediaData, ['poster_url','poster_tv_url']));

                    if (isset($posterPath)) {
                        $posterUrl = $this->uploadToSpaces($posterPath);
                        if ($posterUrl) {
                            $media->poster_url = extractFileNameFromUrl($posterUrl,'episode');
                        }
                    }
                    if (isset($posterTvPath)) {
                        $posterTvUrl = $this->uploadToSpaces($posterTvPath);
                        if ($posterTvUrl) {
                            $media->poster_tv_url = extractFileNameFromUrl($posterTvUrl,'episode');
                        }
                    }

                    $media->save();
                }

                Schema::enableForeignKeyConstraints();
            }
        }

        private function uploadToSpaces($publicPath)
        {
            $localFilePath = public_path($publicPath);
            $remoteFilePath = 'tvshow/episode/image/' . basename($publicPath);

            if (file_exists($localFilePath)) {
                // Get the active storage disk from the environment
                $disk = env('ACTIVE_STORAGE', 'local');

                if ($disk === 'local') {
                    // Store in the public directory for local storage
                    Storage::disk($disk)->put('public/' . $remoteFilePath, file_get_contents($localFilePath));
                    return asset('storage/' . $remoteFilePath);
                } else {
                    // Upload to the specified storage disk
                    Storage::disk($disk)->put($remoteFilePath, file_get_contents($localFilePath));
                    return Storage::disk($disk)->url($remoteFilePath);
                }
            }

            return false;
        }


    }
