<?php

namespace Modules\Installer\Http\Controllers\Backend;

use Illuminate\Routing\Controller;
use Modules\Installer\Helpers\PermissionsChecker;

class PermissionsController extends Controller
{
    /**
     * @var PermissionsChecker
     */
    protected $permissions;

    /**
     * @param  PermissionsChecker  $checker
     */
    public function __construct(PermissionsChecker $checker)
    {
        $this->permissions = $checker;
    }

    /**
     * Display the permissions check page.
     *
     * @return \Illuminate\View\View
     */
    public function permissions()
    {
        $permissions = $this->permissions->check(
            config('installer.permissions')
        );

        return view('installer::backend.permissions', compact('permissions'));
    }
}
