<?php

namespace Modules\Video\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Subscriptions\Transformers\PlanResource;
use Modules\Entertainment\Models\Watchlist;
use Modules\Subscriptions\Models\Plan;
use Modules\Entertainment\Models\Entertainment;

class VideoResourceBannerV3 extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request): array
    {
         return [
             'poster_image' => setBaseUrlWithFileName($this->poster_image,'image','video'),
             'poster_tv_image' => setBaseUrlWithFileName($this->poster_tv_url,'image','video'),
             'details'=>[
                'id' => $this->id,
                'name' => $this->name,
                'type' => $this->type ?? 'video',
                'release_date' => $this->release_date ? formatDate($this->release_date):null,
                'access' => $this->access,
                'is_restricted' => $this->is_restricted,
                'is_device_supported'=> $this->isDeviceSupported,
                "has_content_access"=> $this->has_content_access ?? 0,
                "required_plan_level"=>$this->required_plan_level,
                'is_in_watchlist' => $this->is_watch_list ?? 0,
                'language' => $this->language ?? 'english',
                'duration' => $this->duration ?? null,
                'is_restricted' => $this->is_restricted ?? 0,
                'imdb_rating' => $this->IMDb_rating,
             ],
             'trailer_data'=>[
                'trailer_url_type' => $this->trailer_url_type,
                'trailer_url' => $this->trailer_url_type == 'Local' ? setBaseUrlWithFileName($this->trailer_url) : $this->trailer_url,
             ]
        ];
    }
}
