<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ScopedMoviesSampleExport implements FromArray, WithHeadings, ShouldAutoSize
{
    public function array(): array
    {
        // Return sample data for movies import
        return [
            [
                'The Dark Knight',
                'When the menace known as the Joker wreaks havoc and chaos on the people of Gotham, Batman must accept one of the greatest psychological and physical tests of his ability to fight injustice.',
                'movie',
                'free',
                'active',
                'english',
                '9.0',
                'PG-13',
                '02:32',
                '2008-07-18',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=EXeTwQWrcwY',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=EXeTwQWrcwY',
                'Action, Crime, Drama',
                'Christian Bale, Heath Ledger, Aaron Eckhart',
                'Christopher Nolan',
                'United States, United Kingdom',
                '0',
                '0.00',
                'one_time',
                '30',
                '0.00',
                'all',
                'true',
                'false',
                'https://picsum.photos/800/600',
                'Action Description',   
                'https://picsum.photos/800/600',
                'Christian Bale Bio',
                '1974-11-11',
                'Los Angeles, California, USA' , 
                'https://picsum.photos/800/600',
                'Christian Bale Bio',
                '1974-11-11',
                'Los Angeles, California, USA'
            ],
            [
                'Inception',
                'A thief who steals corporate secrets through the use of dream-sharing technology is given the inverse task of planting an idea into the mind of a C.E.O.',
                'movie',
                'paid',
                'active',
                'english',
                '8.8',
                'PG-13',
                '02:28',
                '2010-07-16',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=YoHD9XEInc0',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=YoHD9XEInc0',
                'Action, Sci-Fi, Thriller',
                'Leonardo DiCaprio, Marion Cotillard, Tom Hardy',
                'Dev Nolan',
                'United States, United Kingdom',
                '2',
                '5.99',
                'rental',
                '7',
                '10.00',
                'premium',
                'true',
                'false',
                'https://picsum.photos/800/600',
                'Sci-Fi Description',
                'https://picsum.photos/800/600',
                'Leonardo DiCaprio Bio',
                '1974-11-11',
                'Los Angeles, California, USA' , 
                'https://picsum.photos/800/600',
                'Leonardo DiCaprio Bio',
                '1974-11-11',
                'Los Angeles, California, USA'
            ],
            [
                'The Matrix',
                'A computer hacker learns from mysterious rebels about the true nature of his reality and his role in the war against its controllers.',
                'movie',
                'pay-per-view',
                'active',
                'english',
                '8.7',
                'R',
                '02:16',
                '1999-03-31',
                'true',
                'YouTube',
                'https://www.youtube.com/watch?v=m8e-FF8MsqU',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=m8e-FF8MsqU',
                'Action, Sci-Fi',
                'Keanu Reeves, Laurence Fishburne, Carrie-Anne Moss',
                'Lana Wachowski, Lilly Wachowski',
                'United States, Australia',
                '3',
                '3.99',
                'rental',
                '3',
                '0.00',
                'all',
                'true',
                'false',
                'https://picsum.photos/800/600',
                'Sci-Fi Description',
                'https://picsum.photos/800/600',
                'Leonardo DiCaprio Bio',
                '1974-11-11',
                'Los Angeles, California, USA' , 
                'https://picsum.photos/800/600',
                'Leonardo DiCaprio Bio',
                '1974-11-11',
                'Los Angeles, California, USA'
            ],
            [
                'Pulp Fiction',
                'The lives of two mob hitmen, a boxer, a gangster and his wife, and a pair of diner bandits intertwine in four tales of violence and redemption.',
                'movie',
                'free',
                'inactive',
                'english',
                '8.9',
                'R',
                '02:34',
                '1994-10-14',
                'true',
                'YouTube',
                'https://www.youtube.com/watch?v=s7EdQ4FqbhY',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=s7EdQ4FqbhY',
                'Crime, Drama',
                'John Travolta, Uma Thurman, Samuel L. Jackson',
                'Quentin Tarantino',
                'United States',
                '0',
                '0.00',
                'one_time',
                '',
                '0.00',
                'all',
                'false',
                'false',
                'https://picsum.photos/800/600',
                'Crime Description',
                'https://picsum.photos/800/600',
                'John Travolta Bio',
                '1954-02-18',
                'New York City, New York, USA' , 
                'https://picsum.photos/800/600',
                'John Travolta Bio',
                '1954-02-18',
                'New York City, New York, USA'
            ],
            [
                'The Shawshank Redemption',
                'Two imprisoned men bond over a number of years, finding solace and eventual redemption through acts of common decency.',
                'movie',
                'free',
                'active',
                'english',
                '9.3',
                'R',
                '02:22',
                '1994-09-23',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=6hB3S9bIaco',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=6hB3S9bIaco',
                'Drama',
                'Tim Robbins, Morgan Freeman, Bob Gunton',
                'Frank Darabont',
                'United States',
                '0',
                '0.00',
                'one_time',
                '',
                '0.00',
                'all',
                'true',
                'false',
                'https://picsum.photos/800/600',
                'Drama Description',
                'https://picsum.photos/800/600',
                'Frank Darabont Bio',
                '1958-01-28',
                'New York City, New York, USA' , 
                'https://picsum.photos/800/600',
                'Frank Darabont Bio',
                '1958-01-28',
                'New York City, New York, USA'
            ]
        ];
    }

    public function headings(): array
    {
        return [
            'Name',
            'Description',
            'Type',
            'Movie Access',
            'Status',
            'Language',
            'IMDb Rating',
            'Content Rating',
            'Duration',
            'Release Date',
            'Is Restricted',
            'Trailer URL Type',
            'Trailer URL',
            'Thumbnail URL',
            'Poster URL',
            'Poster TV URL',
            'Video Upload Type',
            'Video URL Input',
            'Genres',
            'Actors',
            'Directors',
            'Countries',
            'Plan ID',
            'Price',
            'Purchase Type',
            'Access Duration',
            'Discount',
            'Available For',
            'Enable Quality',
            'Enable Subtitle',
            'Genre File URL', 
            'Genre Description',
            'Actor Image URL',
            'Actor Bio',
            'Actor Date of Birth',
            'Actor Place of Birth',
            'Director Image URL',
            'Director Bio',
            'Director Date of Birth',
            'Director Place of Birth'
        ];
    }
}
