<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ScopedTvShowsSampleExport implements FromArray, WithHeadings, ShouldAutoSize
{
    public function array(): array
    {
        // Return sample data for TV shows import
        return [
            [
                'Breaking Bad',
                'A high school chemistry teacher diagnosed with inoperable lung cancer turns to manufacturing and selling methamphetamine in order to secure his family\'s future.',
                'tvshow',
                'paid',
                'active',
                'english',
                '9.5',
                'TV-MA',
                '45',
                '2008-01-20',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=HhesaQXLuRY',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',   
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=HhesaQXLuRY',
                'Crime, Drama, Thriller',
                'Bryan Cranston, Aaron Paul, Anna Gunn',
                'Vince Gilligan',
                'United States',
                '2',
                '9.99',
                'subscription',
                '30',
                '0.00',
                'premium',
                'true',
                'true'
            ],
            [
                'Game of Thrones',
                'Nine noble families fight for control over the lands of Westeros, while an ancient enemy returns after being dormant for millennia.',
                'tvshow',
                'paid',
                'active',
                'english',
                '9.3',
                'TV-MA',
                '55',
                '2011-04-17',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=BpJYNVhGf1s',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=BpJYNVhGf1s',
                'Action, Adventure, Drama',
                'Emilia Clarke, Peter Dinklage, Kit Harington',
                'David Benioff, D.B. Weiss',
                'United States, United Kingdom',
                '3',
                '14.99',
                'subscription',
                '30',
                '0.00',
                'premium',
                'true',
                'true'
            ],
            [
                'The Office',
                'A mockumentary on a group of typical office workers, where the workday consists of ego clashes, inappropriate behavior, and tedium.',
                'tvshow',
                'free',
                'active',
                'english',
                '8.9',
                'TV-14',
                '22',
                '2005-03-24',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=UZjOKhVlqgY',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',   
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=UZjOKhVlqgY',
                'Comedy',
                'Steve Carell, John Krasinski, Jenna Fischer',
                'Greg Daniels',
                'United States',
                '0',
                '0.00',
                'one_time',
                '',
                '0.00',
                'all',
                'true',
                'true'
            ],
            [
                'Stranger Things',
                'When a young boy vanishes, a small town uncovers a mystery involving secret experiments, terrifying supernatural forces, and one strange little girl.',
                'tvshow',
                'paid',
                'active',
                'english',
                '8.7',
                'TV-14',
                '50',
                '2016-07-15',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=b9EkMc79ZSU',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=b9EkMc79ZSU',
                'Drama, Fantasy, Horror',
                'Millie Bobby Brown, Finn Wolfhard, Winona Ryder',
                'Matt Duffer, Ross Duffer',
                'United States',
                '2',
                '12.99',
                'subscription',
                '30',
                '0.00',
                'premium',
                'true',
                'true'
            ],
            [
                'Friends',
                'Follows the personal and professional lives of six twenty to thirty-something-year-old friends living in Manhattan.',
                'tvshow',
                'free',
                'active',
                'english',
                '8.9',
                'TV-14',
                '22',
                '1994-09-22',
                'false',
                'YouTube',
                'https://www.youtube.com/watch?v=hDNNmeeOd1Q',
                'https://picsum.photos/800/600',
                'https://picsum.photos/1200/800',
                'https://picsum.photos/1200/800',
                'YouTube',
                'https://www.youtube.com/watch?v=hDNNmeeOd1Q',
                'Comedy, Romance',
                'Jennifer Aniston, Courteney Cox, Lisa Kudrow',
                'David Crane, Marta Kauffman',
                'United States',
                '1',
                '0.00',
                'one_time',
                '',
                '0.00',
                'all',
                'true',
                'true'
            ]
        ];
    }

    public function headings(): array
    {
        return [
            'Name',
            'Description',
            'Type',
            'Tv Show Access',
            'Status',
            'Language',
            'IMDb Rating',
            'Content Rating',
            'Duration',
            'Release Date',
            'Is Restricted',
            'Trailer URL Type',
            'Trailer URL',
            'Thumbnail URL',
            'Poster URL',
            'Poster TV URL',
            'Video Upload Type',
            'Video URL Input',
            'Genres',
            'Actors',
            'Directors',
            'Countries',
            'Plan ID',
            'Price',
            'Purchase Type',
            'Access Duration',
            'Discount',
            'Available For',
            'Enable Quality',
            'Enable Subtitle'
        ];
    }
}
