<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class ClipsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        DB::table('clips')->truncate();

        $clips = [
            [
                'content_id' => 1,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/WI7ePVquOtk?si=VA0nuamHvD-zeS2S',
                'poster_url' => 'tumse_pyar_lofi_love_mix.png',
                'tv_poster_url' => 'tumse_pyar_lofi_love_mix.png',
                'title' => 'Lofi Love Mix Clip',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 2,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/7cPMriE8fKU?si=Cg3fbsGTtlxUoEMy',
                'poster_url' => 'seize_your_life.png',
                'tv_poster_url' => 'seize_your_life.png',
                'title' => 'Seize Your Life Motivation',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 1,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/pmLP0QQPqFw?si=kd3uvLlmQeAOIdMw',
                'poster_url' => 'the_smiling_shadows_poster.png',
                'tv_poster_url' => 'the_smiling_shadows_thumb.webp',
                'title' => 'Smiling Shadows Teaser',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 21,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/gEF9GiwHTdc?si=dc8Yftad5lk3Iy5Y',
                'poster_url' => 'operation_viper_poster.png',
                'tv_poster_url' => 'operation_viper_thumb.png',
                'title' => 'Operation Viper Action',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 3,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/JDbwEQG2cqI?si=6BMw5MalDfTdFOsi',
                'poster_url' => 'serenity_of_nature.png',
                'tv_poster_url' => 'serenity_of_nature.png',
                'title' => 'Nature Calmness',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 4,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/wxL8bVJhXCM?si=vMnSbMh8LJo9POxu',
                'poster_url' => 'shadow_pursuit_poster.png',
                'tv_poster_url' => 'shadow_pursuit_thumb.png',
                'title' => 'Shadow Pursuit Chase',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 22,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/9j6p7ajuh-E?si=VRWfLmNsJ5_ujAg0',
                'poster_url' => 'the_cure_final_redemption_poster.png',
                'tv_poster_url' => 'the_cure_final_redemption_thumb.png',
                'title' => 'The Cure Trailer',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 6,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/wM6exo00T5I?si=gCTV_d4h032YhHzM',
                'poster_url' => 'echoes_of_valor.png',
                'tv_poster_url' => 'echoes_of_valor.png',
                'title' => 'Echoes of Valor Highlight',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 4,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/RQSmfzfg2MY?si=kPpmh2xnEBDX-7OE',
                'poster_url' => 'run_for_your_life.png',
                'tv_poster_url' => 'run_for_your_life.png',
                'title' => 'Run - Survival Mode',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 2,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/Z7MMTmVZcVs?si=wMJm7eiVAw4sxMMd',
                'poster_url' => 'gunslingers_justice_poster.png',
                'tv_poster_url' => 'gunslingers_justice_thumb.png',
                'title' => 'Justice Served',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 23,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/qokW76nsM4Y?si=mCfHQbDPujKYBb_o',
                'poster_url' => 'the_gunfighters_redemption_poster.png',
                'tv_poster_url' => 'the_gunfighters_redemption_thumb.webp',
                'title' => 'Gunfighter Duel',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 5,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/oomCIXGzsR0?si=UwoW4DyRpHcyAET6',
                'poster_url' => 'cityscape_escapade.png',
                'tv_poster_url' => 'cityscape_escapade.png',
                'title' => 'City Lights',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 3,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/a_z4IuxAqpE?si=er9XhFerfQkQAX3g',
                'poster_url' => 'raziels_daring_rescue_poster.png',
                'tv_poster_url' => 'raziels_daring_rescue_thumb.png',
                'title' => 'Raziel Magic Moment',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 24,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/_YYmfM2TfUA?si=YZ-U3ucPdf_zBUUr',
                'poster_url' => 'daizys_enchanted_journey_poster.png',
                'tv_poster_url' => 'daizys_enchanted_journey_thumb.webp',
                'title' => 'Enchanted Forest',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 7,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/LbN9LbuBHk0?si=r-ejAvb48w0a3tic',
                'poster_url' => 'victory_vibes.png',
                'tv_poster_url' => 'victory_vibes.png',
                'title' => 'Winning Moment',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 5,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/PJlmYh27MHg?si=xkSO89CT6Jd_jor2',
                'poster_url' => 'veil_of_darkness_poster.png',
                'tv_poster_url' => 'veil_of_darkness_thumb.png',
                'title' => 'Darkness Falls',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 25,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/LBBni_-tMNs?si=lKOBiWR56U3yy7Gu',
                'poster_url' => 'secrets_of_zambezia_poster.png',
                'tv_poster_url' => 'secrets_of_zambezia_thumb.png',
                'title' => 'Fly High',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 8,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/xqbb1FCX6wM?si=CtUefpTBezN0tP8-',
                'poster_url' => 'midnight_thrills.png',
                'tv_poster_url' => 'midnight_thrills.png',
                'title' => 'Midnight Scare',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 6,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/S1i5coU-0_Q?si=YUTmicQFwTWS6DEh',
                'poster_url' => 'the_hidden_truth_poster.png',
                'tv_poster_url' => 'the_hidden_truth_thumb.png',
                'title' => 'Truth Revealed',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 26,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/hZ1Rb9hC4JY?si=LELLKsF46bCcc3J9',
                'poster_url' => 'the_new_empire_poster.png',
                'tv_poster_url' => 'the_new_empire_thumb.png',
                'title' => 'Empire Strikes',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 9,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/gLYTObRhcSY?si=10kFIVk_bL-x-H84',
                'poster_url' => 'hearts_entwined.png',
                'tv_poster_url' => 'hearts_entwined.png',
                'title' => 'Romantic Gaze',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 7,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/gCQRvfWvdt8?si=KRoGL_s-XoSOKJ-i',
                'poster_url' => 'the_forgotten_road_poster.png',
                'tv_poster_url' => 'the_forgotten_road_thumb.png',
                'title' => 'Forgotten Path',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 27,
                'content_type' => 'movie',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/usdcpWXPaDY?si=utsn-As0lUuPFtx7',
                'poster_url' => 'the_daring_player_poster.png',
                'tv_poster_url' => 'the_daring_player_thumb.webp',
                'title' => 'Daring Stunt',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 10,
                'content_type' => 'video',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/uZNRzc3hWvE?si=cpm3hCMCrRJiH7WR',
                'poster_url' => 'gnomeos_love_stories.png',
                'tv_poster_url' => 'gnomeos_love_stories.png',
                'title' => 'Gnomeo Love',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'content_id' => 8,
                'content_type' => 'tvshow',
                'type' => 'YouTube',
                'url' => 'https://youtu.be/pJCgeOAKXyg?si=Gk5JNJQaMEnimaVK',
                'poster_url' => 'wolfbound_poster.png',
                'tv_poster_url' => 'wolfbound_thumb.png',
                'title' => 'Alpha Wolf',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];

        DB::table('clips')->insert($clips);
        Schema::enableForeignKeyConstraints();
    }
}
